import java.awt.Frame;
import java.awt.Button;
import java.awt.Rectangle;
import java.awt.Graphics;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Event;
import graphics.Slider;


public class ChannelPanel extends MenuPanel {
    Channel     m_Channel;
    BucketPanel m_bpInA;
    BucketPanel m_bpInB;
    public ChannelPanel(Channel channel) {
		super();
		// create property dialog
		Frame frame = new Frame();
		m_Dlg = new ChannelProperties(frame);
		m_Dlg.setResizable(true);
		m_Dlg.resize(200,320);
		m_Dlg.setResizable(false);

		m_Channel = channel;
		setLayout(new BorderLayout(15,15));
		ImagePanel ci = new ImagePanel(m_Channel.m_Image);
        ChannelControl cp = new ChannelControl(m_Channel);
        m_bpInA = new BucketPanel(m_Channel.inA,50,60);
        m_bpInB = new BucketPanel(m_Channel.inB,50,60);
   		add("Center",ci);
		add("South",cp);
		add("West",m_bpInA);
		add("East",m_bpInB);
    }
    public void paint(Graphics g) {
        Rectangle frame=bounds();
    }
    public void myUpdate() {
        m_Channel.inA.setMaxSize(m_Channel.stationA.protocol().sendWindow.maxWindowSize());
        m_Channel.inB.setMaxSize(m_Channel.stationB.protocol().receiveWindow.maxWindowSize());
        m_bpInA.myUpdate(m_Channel.inA);
        m_bpInB.myUpdate(m_Channel.inB);
    }
}

class ChannelSlider extends Slider {
    Channel    m_Channel;
    int        m_iOldValue;
    public ChannelSlider(Channel channel) {
        m_Channel = channel;
        m_iOldValue = 0;
    }
    protected void Motion() {
        m_Channel.setSpeed(GetValue());
        m_iOldValue = GetValue();
    }
}


class ChannelControl extends Panel {
    Channel         m_Channel;
    Button          m_nextStep;
    ChannelSlider   m_ControlSlider;
    public ChannelControl(Channel channel) {
        m_Channel = channel;
        // use GridbagLayoutmanager
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        setLayout(gbl);
        // ####### Insert first row #######
        // Create Objects
        m_nextStep = new Button("Step");
        m_ControlSlider = new ChannelSlider(m_Channel);
        m_ControlSlider.SetHeight(30);
        m_ControlSlider.SetWidth(100);
        m_ControlSlider.SetMinimum(0);
        m_ControlSlider.SetMaximum(100);
        m_ControlSlider.SetValue(0);
        // Set layout of Objects
        // Image
        gbc.anchor = GridBagConstraints.CENTER;
        gbc.insets = new Insets(0,0,0,0);
        gbc.gridwidth = 1;
        gbc.fill = GridBagConstraints.NONE;
//        gbl.setConstraints(imgPanel,gbc);
//        add(imgPanel);
        // Slider
        gbc.insets = new Insets(0,5,0,5);
        gbc.gridwidth = 1;
        gbc.fill = GridBagConstraints.NONE;
        gbl.setConstraints(m_ControlSlider,gbc);
        add(m_ControlSlider);
        // Button
        gbc.insets = new Insets(0,0,0,0);
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.fill = GridBagConstraints.NONE;
        gbl.setConstraints(m_nextStep,gbc);
        add(m_nextStep);
    }
	public boolean action(Event e,Object what)	{
        if (e.target == m_nextStep) {
            if (m_ControlSlider.GetValue()==0) {
                m_Channel.nextStep();
                m_Channel.stationA.m_Timer.newTimeStep();
                m_Channel.stationB.m_Timer.newTimeStep();
            }
        }
        return(true);
    }
}

